#pragma once

// Down-sampling related stuff
#define INLEN         10240000
#define IIRLEN        10240000
#define FIRLEN        409600
#define DEMODLEN      81920
#define OUTLEN        4096
#define DDCLEN        80000
#define FIRTAPSLEN    1023

#define EVENT_FLAGS   CREATE_EVENT_MANUAL_RESET
#define EVENT_ACCESS  EVENT_MODIFY_STATE | SYNCHRONIZE | DELETE

// Audio related
#define BLOCK_SIZE  16384
#define BLOCK_COUNT 20

class AudioStream {
public: /* Methods */
	AudioStream();
	~AudioStream();

	void bufferData(float* f);
	void setChannelFreq(float f, Channel c);

public: /* Members */
	struct tParam { // Thread parameter
		tParam(AudioStream* _as, Channel _c, Part _p)
			: as(_as), c(_c), p(_p) {}
		AudioStream* as;
		Channel c;
		Part p;
	};

private: /* Methods */
	static DWORD WINAPI threadEntry(LPVOID param);
	static DWORD WINAPI demodEntry(LPVOID param);
	DWORD processThread(Channel c, Part p);
	DWORD demodThread(void);
	void swapBufPtr(void);

	void demodAndScale(Channel c);

	// Audio out related

private: /* Members */
	bool programRunning;
	int bufferedData;
	HANDLE dataReadyEvent[2][2];
	HANDLE procDoneEvent[2][2];

	HANDLE threads[4];
	HANDLE demodHandle;
	float freq1, freq2;

	Ipp32f* inBuf;        // buf ptr to the buffer we are filling
	Ipp32f* procBuf;      // buf ptr to the buffer we are processing
	Ipp32f* buf[2];

	Ipp32f* ddc[2][2];

	IppsIIRState_32f* iirState[2][2]; // iir state for real channels 
	Ipp32f  iirTaps[8];               // Ipps IIR taps
	Ipp32f* iir[2][2];                // Buffer for in-place iir
 
	IppsFIRState_32f* firState[2][2];
	Ipp32f* firTaps;
	Ipp32f* fir[2][2];

	IppsIIRState_32f* audioLowPass;
	Ipp32f  alpTaps[8];
	IppsIIRState_32f* fmDeemphasis;
	Ipp32f fmdTaps[8];

	Ipp32f* demodIn[2][2];
	Ipp32f* demodOut[2];

	Ipp32f* channelOut[2];

	Ipp16s* audioIn;
};

inline void AudioStream::swapBufPtr(void) 
{
	Ipp32f* t = inBuf;
	inBuf = procBuf;
	procBuf = t;
}